﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<ItineraryDetailsViewModel>" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">Plan My Night - <%:Model.Name%></asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <div class="dual">
        <div class="panel">
            <h2><span>Itinerary: <%:Model.Name%></span></h2>
            
            <div class="innerPanel">
            
                <div class="subheader">
                    <% if (Model.IsPublic) { %>
                    <span class="rating <%=ItineraryHelper.GetRatingCssClass(Model.Rating)%>"><span>Rating: <%=ItineraryHelper.GetRatingLabel(Model.Rating)%></span></span>
                        |
                    <% } %>
                    <% if (Model.CanEdit) { %>
                        <%=Model.IsPublic ? "Public" : "Private"%>
                        <img src="<%=Url.Content("~/Content/Images/myitineraries_icon_" + (Model.IsPublic ? "public" : "private") + ".png")%>" width="14" height="15" alt="" />
                    <% } else { %>
                        By <%= Html.ActionLink<ItinerariesController>(c => c.ByUser(Model.UserId), Model.Owner ?? "Anonymous")%>
                    <% } %>
                </div>
                
                <div class="items">
                    <h3><%:Model.Description%></h3>
                    <span class="bulkAdd"><a class="bulkAdd" href="<%=Html.AttributeEncode(Model.AddActivitiesLink)%>">Add activities to my itinerary</a></span>

                    <% if (Model.EstimatedMinutes > 0 && Model.ActivitiesCount > 1) { %>
                    <p class="estimatedTime">
                        Total estimated time:
                        <%:TimeHelper.GetFriendlyTime(Model.EstimatedMinutes)%> + <span id="travelEstimate">travel time</span>.
                    </p>
                    <% } %>

                    <ol class="activities">
                        <% foreach (var item in Model.Activities) %>
                        <% { %>
                        <li>
                            <p>
                                <a href="<%=Html.AttributeEncode(item.DetailsLink)%>">
                                    <strong><%:item.Entity.Name%></strong>
                                </a><br />
                                <%:item.Entity.Street%><br />
                                <%:item.Entity.City%>,
                                <%:item.Entity.State%>
                                | Phone:
                                <%:item.Entity.PhoneNumber%>
                                <% if (item.EstimatedMinutes > 0) { %>
                                    <br /><em>Estimated time: <%= item.EstimatedMinutes %> minutes.</em>
                                <% } %>
                            </p>
                        </li>
                        <% } %>
                    </ol>
                </div>
                
                <div class="toolbox">
                    <%--Addin Boxes--%>
                    <%
                        foreach(var action in Model.AddinBoxes)
                        {
                            Html.RenderAddinRoute(action);
                        }
                    %>
                    <div class="pager">
                        <ul>
                        <% if (Model.CanEdit)
                           { %>
                            <li><%=Html.ActionLink<ItinerariesController>(c => c.Edit(Model.Id), "Edit")%></li>
                            <li>
                                <form method="post" action="<%=this.Url.Action(Model.IsPublic ? "MakePrivate" : "MakePublic", new { id = Model.Id }) %>" class="inline">
                                    <%=Html.SubmitButton("submit", Model.IsPublic ? "Make Private" : "Make Public")%>
                                    <%=Html.AntiForgeryToken()%>
                                </form>
                            </li>
                        <% } %>
                        
                        <%--Addin links--%>
                        <% foreach(var link in Model.AddinLinks) { %>
                            <li><%= Html.RouteLink(link.LinkText, link.RouteLink, link.Attributes)%></li>
                        <% } %>
                        
                        <% if (Model.CanRate)
                           { %>
                            <li>
                                <% using (Html.BeginForm<ItinerariesController>(c => c.Rate(Model.Id), FormMethod.Post, new { @class = "inline rating" })) %>
                                <% { %>
                                    <%=Html.AntiForgeryToken()%>
                                    Rate:
                                    <div class="ratingEditable" style="display:inline-block">
                                        <div id="ratingStaticEditable" class="static">
                                            <input name="Rating" type="radio" value="1" class="auto-submit-star" />
                                            <input name="Rating" type="radio" value="2" class="auto-submit-star" />
                                            <input name="Rating" type="radio" value="3" class="auto-submit-star" />
                                            <input name="Rating" type="radio" value="4" class="auto-submit-star" />
                                            <input name="Rating" type="radio" value="5" class="auto-submit-star" />
                                            <input name="rate" type="submit" value="Rate" class="submit-star" />
                                        </div>
                                        <div id="ratingAjaxEditable" class="ajax" style="display:none;">                        
                                            <a id="ratingAjaxEditable_A" title="Vote" style="text-decoration: none">
                                                <span id="ratingAjaxEditable_Star_1" class="ratingStar filledRatingStar">&nbsp;</span>
                                                <span id="ratingAjaxEditable_Star_2" class="ratingStar filledRatingStar">&nbsp;</span>
                                                <span id="ratingAjaxEditable_Star_3" class="ratingStar emptyRatingStar">&nbsp;</span>
                                                <span id="ratingAjaxEditable_Star_4" class="ratingStar emptyRatingStar">&nbsp;</span>
                                                <span id="ratingAjaxEditable_Star_5" class="ratingStar emptyRatingStar">&nbsp;</span>                
                                            </a>
                                        </div>  
                                    </div>
                                <% } %>
                            </li>
                        <% } else if(Model.IsPublic) { %>
                            <li><span class="rating <%=ItineraryHelper.GetRatingCssClass(Model.Rating)%>"><span>Rating: <%=ItineraryHelper.GetRatingLabel(Model.Rating)%></span></span></li>
                        <% } %>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <% Html.RenderAction<ItinerariesController>(c => c.ListComments(Model.Id)); %>
    </div>
    
    <% if (Ajax.JavaScriptEnabled()) { %>
        <% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js"), "http://ajax.Microsoft.com/ajax/jQuery/jquery-1.3.2.min.js"); %>
        
        <% if(Model.CanRate) { %>
            <%--Ms Ajax Rating --%>
            <% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/MicrosoftAjax.js"), "http://ajax.Microsoft.com/ajax/beta/0909/MicrosoftAjax.js"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/AjaxControlToolkit/AjaxControlToolkit.Compat.Timer.Timer.js"), "rating"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/AjaxControlToolkit/AjaxControlToolkit.Common.Common.js"), "rating"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/AjaxControlToolkit/AjaxControlToolkit.ExtenderBase.BaseScripts.js"), "rating"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/AjaxControlToolkit/AjaxControlToolkit.Animation.Animations.js"), "rating"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/AjaxControlToolkit/AjaxControlToolkit.Rating.RatingBehavior.js"), "rating"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.itinerary.rating.js"), "rating"); %>
        <% } %>    
        
        <% if (Model.ActivitiesCount > 1) { %>
        <div id="itineraryMap" class="off">
            <% Ajax.RegisterClientScriptInclude("http://ecn.dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=6.2&mkt=en-us"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.common.js"), "itinerary"); %>
            <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.itinerary.routes.js"), "itinerary"); %>
            <%
                var pointsScript = "var rawPoints = [];";
                foreach (var activity in Model.Activities)
                {
                    pointsScript += string.Format(System.Globalization.CultureInfo.InvariantCulture, "\nrawPoints.push({{ name:'{0}', point:'POINT ({1} {2}' }});", activity.Entity.Name.Replace("'", "\\'"), activity.Entity.Location[0], activity.Entity.Location[1]);
                }
            %>
            <% Ajax.RegisterClientScriptBlock(pointsScript); %>
            <div class="loading">
                Loading Map...</div>
            <div id="itineraryRouteSelector" class="off">
                Directions: <a href="#" onclick="return false" id="itineraryDrivingSelector">Driving</a>
                | <a href="#" onclick="return false" id="itineraryWalkingSelector">Walking</a>
            </div>
            <div id="itineraryRouteDetails">
            </div>
            <div id="itineraryRouteMap" style="visibility: hidden; width: 550px; height: 350px;">
            </div>
        </div>
        <script type="text/javascript">
            document.getElementById("itineraryMap").className = "";
        </script>
        <% } %>
    <% } %>
</asp:Content>
